/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.junit.jupiter.api.Test;

public class BeanRelationFixerTest {
    @Test
    public void of_setter() {
        BeanRelationFixer testInstance = BeanRelationFixer.of(DummyTarget::setProp1);
        DummyTarget target = new DummyTarget();
        String input = "toto";
        testInstance.apply((Object)target, (Object)input);
        Assertions.assertThat((String)target.getProp1()).isEqualTo(input);
    }

    @Test
    public void of_setter_getter() {
        BeanRelationFixer testInstance = BeanRelationFixer.of(Country::setPresident, President::setCountry);
        Country target = new Country();
        President president = new President();
        testInstance.apply((Object)target, (Object)president);
        Assertions.assertThat((Object)target.getPresident()).isEqualTo((Object)president);
        Assertions.assertThat((Object)president.getCountry()).isEqualTo((Object)target);
    }

    @Test
    public void of_setter_getter_collection() {
        BeanRelationFixer testInstance = BeanRelationFixer.of(DummyTarget::setProp2, DummyTarget::getProp2, ArrayList::new);
        DummyTarget target = new DummyTarget();
        testInstance.apply((Object)target, (Object)2);
        testInstance.apply((Object)target, (Object)5);
        Assertions.assertThat(target.getProp2()).isEqualTo((Object)Arrays.asList((Object[])new Integer[]{2, 5}));
    }

    @Test
    public void of_setter_getter_collection_bidirectional() {
        BeanRelationFixer testInstance = BeanRelationFixer.of(Country::setCities, Country::getCities, ArrayList::new, City::setCountry);
        Country target = new Country();
        City city = new City();
        testInstance.apply((Object)target, (Object)city);
        Assertions.assertThat((Object)Iterables.first(target.getCities())).isEqualTo((Object)city);
        Assertions.assertThat((Object)city.getCountry()).isEqualTo((Object)target);
    }

    private static class City {
        private Country country;

        private City() {
        }

        public Country getCountry() {
            return this.country;
        }

        public void setCountry(Country country) {
            this.country = country;
        }
    }

    private static class President {
        private Country country;

        private President() {
        }

        public Country getCountry() {
            return this.country;
        }

        public void setCountry(Country country) {
            this.country = country;
        }
    }

    private static class Country {
        private President president;
        private List<City> cities;

        private Country() {
        }

        public President getPresident() {
            return this.president;
        }

        public void setPresident(President president) {
            this.president = president;
        }

        public List<City> getCities() {
            return this.cities;
        }

        public void setCities(List<City> cities) {
            this.cities = cities;
        }
    }

    private static class DummyTarget {
        private String prop1;
        private List<Integer> prop2;

        private DummyTarget() {
        }

        public String getProp1() {
            return this.prop1;
        }

        public void setProp1(String prop1) {
            this.prop1 = prop1;
        }

        public List<Integer> getProp2() {
            return this.prop2;
        }

        public void setProp2(List<Integer> prop2) {
            this.prop2 = prop2;
        }
    }
}

